using Godot;
using Rokojori;

[Tool, GlobalClass]
public partial class FootSteps: Action
{
  [Export]
  public Node3D decalTransform;

  [Export]
  public float offset = 0.1f;

  [Export]
  public Decal leftStep;
  
  [Export]
  public Decal rightStep;


  [Export]
  public int maxPairs = 10;


  [Export]
  public Node footStepsContainer;

  int counter = 0;

  protected override void _OnTrigger()
  {    
    while ( footStepsContainer.GetChildCount() <= counter )
    {
      var index = footStepsContainer.GetChildCount();
      var isLeft = index % 2 == 0;

      footStepsContainer.CreateChildFromDuplicate( isLeft ? leftStep : rightStep );      
    }

    var decal = (Decal)footStepsContainer.GetChild( counter );
    var isCurrentLeft = counter % 2 == 0;
    var offsetDirection = isCurrentLeft ? -1 : 1;

    decal.Modulate = Colors.White;
    decal.GlobalPosition = decalTransform.GlobalPosition + decalTransform.GlobalRight() * offsetDirection * offset;
    decal.SetGlobalYaw( decalTransform.GlobalYawRadians() );

    for ( int i = 0; i < maxPairs * 2; i++ )
    {
      var index = counter - i;

      index = MathX.Repeat( index, footStepsContainer.GetChildCount() );

      if ( index >= footStepsContainer.GetChildCount() )
      {
        break;
      }

      var t = 1.0f - i / ( maxPairs * 2f );

      var childDecal = (Decal)footStepsContainer.GetChild( index );
      childDecal.Modulate = new Color( 1, 1, 1, t );

      // this.LogInfo( i, ">>", t._FFF() );
    }

    counter = ( counter + 1 ) % ( maxPairs * 2 );
  }

}